#include "TCanvas.h"
#include "TDirectory.h"
#include "TH2F.h"
#include "TH1D.h"
#include "TF1.h"
#include "TSpectrum.h"
#include "TGraph.h"

#include <fstream>
#include <iostream>


int dacfit(char * hname,float max=5000,float range=300,float fac=1e-5){

  TCanvas *c1= new TCanvas("c1");
  c1->Divide(7,6);
  TDirectory * dir=gDirectory;
  TH2F *h1= 0;
  h1 = ((TH2F *) dir->Get(hname));
  int ny=h1->GetNbinsY()-1;
  FILE *fp=fopen(hname,"w");

  TSpectrum *s = new TSpectrum();
  TF1 * g0 = new TF1("g0","gaus",0,1000);
  for (int i=0;i<ny;i++){
    c1->cd(i+1);
    TH1D *h=   h1->ProjectionX("px",i+1,i+1);

   
    int nfound = s->Search(h,10,"", fac); 
    Float_t *xpeaks = s->GetPositionX();
    float xmax=0;
    float xmin=1000;
    for (int k = 0; k < nfound; k++){
      // printf("%d %f\n",k,xpeaks[k]);
      if (xpeaks[k]>xmax) xmax=xpeaks[k];
      if (xpeaks[k]<xmin) xmin=xpeaks[k];
    } 
    h->Fit(g0,"Q","",xmax-10,xmax+50);
    h->SetMaximum(max);
    h->GetXaxis()->SetRange(0,range);
   
    float fwhm  =0;
    h->Fit(g0,"Q","",g0->GetParameter(1)-g0->GetParameter(2),xmax+50);
    h->DrawCopy();
    float xmean =g0->GetParameter(1);
    float xsigma=g0->GetParameter(2);
    float x0    =g0->GetParameter(0);

    if (xmean-xmin) fwhm=xsigma/(xmean-xmin)*2.35;
    printf("%f %f %f %f %f\n",h1->GetYaxis()->GetBinCenter(i+1),fwhm,xsigma,x0,g0->Integral(0,500));

    fprintf(fp,"%f %f %f %f %f\n",h1->GetYaxis()->GetBinCenter(i+1),fwhm,xsigma,x0,g0->Integral(0,500));

    //  h->Fit("gaus","","",xmin-20,xmin+20);
  }
  c1->Modified();
  c1->Update();
  fclose(fp);
  return 0;
}


int all(){
  gStyle->SetOptStat(0);
  char title[4][30]={"FWHM;U_{bias}(V)","#sigma(ADC channels);U_{bias}(V)","N_{0};U_{bias}(V);","N_{det};U_{bias}(V)"};
  char mtitle[4][30]={"FWHM","sigma","n0","ndet"};

  float max[4]={0.25,20,2000,30000};
  TCanvas *c[4];
  TGraph *gr[4];    
  char name[20];
  for (int i=0;i<4;i++){
    sprintf(name,"c%d",i);
    c[i]= new TCanvas(name,name);
    c[i]->cd()->SetGridy(1);

    TH2F *hframe = new TH2F("hframe",title[i],2,69.9,70.6,2,0,max[i]);
    hframe->Draw();
    // c1->GetFrame()->Draw();
    std::cout << i << name<< std::endl;
    
  }
  int first=1;
  for (int i=0;i<16;i++){
    char fname[128];
    sprintf(fname,"h2dadcdac%03d",i);
    std::ifstream myfile( fname, ios::in  );
    float dac,fwhm,sigma,nph,x0;

    std::cout << fname<< std::endl;

    int j=0;
    if (myfile.is_open()){
      for (int ix=0;ix<4;ix++){
	gr[ix]= new TGraph(17); 
	gr[ix]->SetMarkerStyle(20+i%8);
      }
      while (! myfile.eof() ){
	myfile >>dac >> fwhm >> sigma >> x0 >> nph;
	dac=70.6-dac/11;
	gr[0]->SetPoint(j,dac,fwhm);
	gr[1]->SetPoint(j,dac,sigma);
	gr[2]->SetPoint(j,dac,x0);
	gr[3]->SetPoint(j,dac,nph);

	std::cout << dac <<" " <<fwhm <<" " << sigma<< std::endl;
	j++;
      }
      myfile.close();
      if (first){
	sprintf (name,"LPSAME"); 
	first=0;
      } else {
	sprintf (name,"LPSAME");
      }
      for (int k=0;k<4;k++){
	printf("j=%d %s\n",j,name);
      	gr[k]->Set(j-1);
	c[k]->cd();
	gr[k]->Draw(name);
      }
    }
    
    
  }

  for (int i=0;i<4;i++){


    c[i]->Modified();
    c[i]->Update();
    sprintf(fname,"%s.pdf",mtitle[i]);
    c[i]->SaveAs(fname);
    sprintf(fname,"%s.png",mtitle[i]);
    c[i]->SaveAs(fname);
  }
  return 0;

}
