#include "TStyle.h"
#include "TH2F.h"
#include "TList.h"
#include "TCanvas.h"
#include "TDirectory.h"

#include <stdio.h>

const int ind[16]={0,1,2,3,7,6,5,4,8,9,10,11,15,14,13,12};
int mppcplot(char *pname="h2d0"){ 
  gStyle->SetOptStat(0);     
  gStyle->SetPalette(1);     
  printf("--------------\n");
  TCanvas *c1=new TCanvas("c1","c1",1000,1000);  
  c1->Divide(4,4);
  char mname[128];
  
  TList *list = new TList;
  
  
  
  for (int i=0;i<16;i++){
   
    sprintf(mname,"%s%02d",pname,i);
    c1->cd(ind[i]+1);
    TH2F *h3=(TH2F *)gDirectory->Get(mname);
    sprintf(mname,"c2d0%02d",i);
    TH2F *h4=(TH2F *)h3->Clone(mname);

   double mm=h4->GetMinimum();
   mm=0; 
   for (int k=0;k<h4->GetNbinsX();k++){
     mm+=h4->GetBinContent(k+1,1); 
     mm+=h4->GetBinContent(k+1,h4->GetNbinsY());
   }
   mm/=(2*h4->GetNbinsX());
   float mmx=10000;
   for (int k=0;k<h4->GetNbinsX();k++){
     for (int l=0;l<h4->GetNbinsY();l++){
       double val=h4->GetBinContent(k+1,l+1)-mm-mmx;
       if (val<0) val=0;
       h4->SetBinContent(k+1,l+1,val);
     }
   }

   double ma=h4->GetMaximum();
   printf("%s min=%f max=%f\n",mname, mm,ma);
   //h4->SetMinimum(0);
   //h4->SetMaximum(100000-mmx);
   h4->Draw("colz");
   list->Add(h4);
 }

 TH2F *h0 = (TH2F *)(gDirectory->Get("h2d001")->Clone("h"));
 h0->Reset();
 h0->Merge(list);

 TCanvas *c2=new TCanvas("c2","c2",1000,1000);
 c2->cd(1);  
 h0->GetMaximum();
 h0->GetMinimum();
 h0->Draw("colz");
 return 0;
}


