#include <formatio.h>
#include <cvirte.h>
#include <userint.h>
#include "AitGui.h"
#include "XYSCAN.h"

#include <stdbool.h>
#include "AitInterface.h"
#include "AitMduManager_DEF.h"

#include "H1D.h"
#include "H2D.h"
#include "H3D.h"


typedef unsigned short ushort;
typedef unsigned int uint;

static int ait;
static int xyscan;
//#define MIKRO

#ifdef MIKRO
#include "MIKRO.h"
#endif

static int daq_on;
static int plothandle[4]= {0,0,0, 0};
static int tfID;
static int controlID;
static int verbose;

#define MAX_THREADS 10

static CmtThreadPoolHandle poolHandle = 0;


/*

x: 140000 280000

*/

//**************************** missing declarations in the library
char strbuf[0xFF];

int gLog=0;

int printf(const char *format, ...) {
  va_list aptr;
  int ret;
  FILE *flog;

  va_start(aptr, format);
  ret = vsprintf(strbuf, format, aptr);
  va_end(aptr);
  SetCtrlVal(ait,AIT_STDIO,strbuf);

  if (gLog) {
    flog = fopen ("stdio.log", "a");
    fprintf (flog, "%s", strbuf);
    fclose (flog);
  }
  return(ret);
}



static int timeout=0;    
int CVICALLBACK SetTimeoutCB (int panel, int control, int event,
															void *callbackData, int eventData1, int eventData2) {
	switch (event) {
		case EVENT_TIMER_TICK:
			timeout=1;
			printf("#### Timeout\n"); 
			break;
	}
	return 0;
}



static void start_timer (double tout) {
	timeout = 0;
  SetCtrlAttribute (ait, AIT_TIMER, ATTR_INTERVAL, tout);
  SetCtrlAttribute (ait, AIT_TIMER, ATTR_ENABLED, 1);
}

static void stop_timer ( void ) {
  SetCtrlAttribute (ait, AIT_TIMER, ATTR_ENABLED, 0);
  //DRSSetTimeout();
}



void CVICALLBACK EndOfThread ( CmtThreadPoolHandle poolhandle,
                               CmtThreadFunctionID functionID, unsigned int event,
                               int value, void *callbackData  ) {

  daq_on=0;
  //SetDimming(0);
  printf("End of Thread \n");
  return ;

}

int AitInit() {
  InitializeConnection();
  return 0;
}


int AitValidEvent() {

  return 1;
};

int AitToFile(FILE *fp, int n) {
	const int bsize=10000 ;
	unsigned short a[bsize] ;
	unsigned short buffer[2]={0x1};
	buffer[1] = (unsigned short)(n*CHANNELS*2);  
	for (int eventNum = 0; eventNum < n; eventNum++) {
		
    for (int channel = 0; channel < CHANNELS; channel++) {
			int index = channel+ CHANNELS * eventNum;
			if (index<bsize)
        a[index] = ExtractAdcData(eventNum, channel);
		}
	}
	fwrite(buffer, 2*sizeof(short),1,fp);
	return fwrite(a, 1,buffer[1],fp);
};

int AitFillHistograms(int events) {
  ushort rawAdcData = 0;
  ushort adcData = 0;
  int channelReceived = 0;
  int channelExpected = 0;
  bool includeSaturated = 0; // cbIncludeSaturated.Checked;
  ushort max[CHANNELS];
  ushort min[CHANNELS];
  ushort average[CHANNELS];
  int  total[CHANNELS];
  for (int i = 0; i < CHANNELS; i++) {
    min[i] = 0xFFFF;
    max[i] = 0;
    total[i] = 0;
  }

  double threshold, xysumcut;
  GetCtrlVal (ait, AIT_ADCTHRESHOLD, &threshold);
  GetCtrlVal (ait, AIT_XYCUT, &xysumcut);

  for (int eventNum = 0; eventNum < events; eventNum++) {

    int sum = 0;
    double a[4]= {0,0,0,0} ;
    for (int channel = 0; channel < CHANNELS; channel++) {

      rawAdcData = ExtractAdcData(eventNum, channel);
      if (addChannelNum == true) {
        channelReceived = (rawAdcData >> 12) & 0xF;
        channelExpected = (channel & 0xF);
        if (channelReceived != channelExpected) {

          AddMessage("ERROR in Event %d : Expected channel %d, received %d -ANALYSIS STOPPED", eventNum, channelExpected, channelReceived);

          //EnableRegisterScanTimer(true);
          return eventNum;
        }
      }
      adcData = (ushort)(rawAdcData & 0x0FFF);    // remove channel number
      //if ((includeSaturated == true) || ((includeSaturated == false) && (adcData < (ADCMAX - 2))))

      if (adcData>threshold) H1D_Fill(channel, adcData,1);
      a[channel]=adcData;
      total[channel] = total[channel] + adcData;
      if (adcData > max[channel])
        max[channel] = adcData;
      else if (adcData < min[channel])
        min[channel] = adcData;

      sum += adcData;
    }
    if (sum>threshold) {
      H1D_Fill(10, sum, 1 );
      double x = a[0]/(a[0]+a[1]);
      double y = a[2]/(a[2]+a[3]);
      if (sum>xysumcut) H2D_Fill(0, x, y , 1 );
    }
    histogramTotalEvents++;
  }
  //tbAdcStatistics.Clear();
  for (int channel = 0; channel < CHANNELS; channel++) {
    average[channel] = (ushort)(total[channel] / events);

    if (verbose) AddMessage(" {channel:%d}  : {min:0x%d}  {max:0x%d}  {max-min:%d}  {average:%d}\n", channel + 1, min[channel], max[channel], max[channel] - min[channel], average[channel]);
    //if (channel < (CHANNELS - 1))
    //    tbAdcStatistics.AppendText(Environment.NewLine);

  }
  //SetTextboxToTop(tbAdcStatistics);
  return 1;
};


int CVICALLBACK RefreshGraphs (int panel, int control, int event,
                               void *callbackData, int eventData1, int eventData2) {
  switch (event) {
    case EVENT_TIMER_TICK:
//      if (!daq_on ) return 0;
    case EVENT_COMMIT: {
			
      int ch=0;
			int logy=0;
			int updateplots=0;
      GetCtrlVal(ait,AIT_CH, &ch);
			GetCtrlVal(ait,AIT_LOGY, &logy);
		  GetCtrlVal(ait,AIT_UPDATEPLOTS, &updateplots); 
			if (!updateplots) return 0;
			if (logy){
				SetCtrlAttribute (ait, AIT_GRAPH, ATTR_YMAP_MODE, VAL_LOG);
			  SetCtrlAttribute (ait, AIT_GRAPHSUM, ATTR_YMAP_MODE, VAL_LOG); 
			
			} else {
				SetCtrlAttribute (ait, AIT_GRAPH, ATTR_YMAP_MODE, VAL_LINEAR);
			  SetCtrlAttribute (ait, AIT_GRAPHSUM, ATTR_YMAP_MODE, VAL_LINEAR); 
			
			}
      H1D_Draw(ch,ait,AIT_GRAPH,&plothandle[0]);
      H1D_Draw(10,ait,AIT_GRAPHSUM,&plothandle[1]);
      H2D_Draw(0,ait,AIT_GRAPHXY,&plothandle[2]);
			

    }

    
    break;

  }
  return 0;
}



int CVICALLBACK daq(void *functionData) {


  int neve;
  char filename[0xff];
	char fname[0xff];  
	char pname[0xff];



  int pfreq;
  int enabledoutput;
  int neveold = 0;
  double rate;
  int *args =  (int *) functionData;

  GetCtrlVal(ait, AIT_FILENAME, fname );
	GetCtrlVal(ait, AIT_PATHNAME, pname );
	sprintf(filename,"%s/%s", pname, fname);

  GetCtrlVal(ait,AIT_NEVE, &neve);
  GetCtrlVal(ait,AIT_DEBUG, &verbose);
  GetCtrlVal(ait,AIT_PFREQ, &pfreq);
  GetCtrlVal(ait,AIT_ENABLEDOUTPUT, &enabledoutput);

	
	int range=0;
	int nch = range;
	GetCtrlVal(ait,AIT_MAX, &range);  
	if (range>512) nch = 512;
  
		
  for (int i=0; i<4; i++) {
    char name[0xFF];
    sprintf(name,"adc%d", i);
		
    H1D_Init(i, name,name, range, 0 , range);
    H1D_SetTitleX(0,"ADC");
    H1D_SetTitleY(0,"N");
  }
  H1D_Init(10, "adcsum","adcsum", range, 0 , 4*range);
  H1D_SetTitleX(0,"ADC");
  H1D_SetTitleY(0,"N");

  H2D_Init(0, "cog","Center of gravity", 256, 0 ,1, 256, 0 ,1);
  H2D_SetTitleX(0,"x");
  H2D_SetTitleY(0,"y");



  FILE *fp= NULL;

  if (enabledoutput) {
    if (args[0]) fp =  fopen(filename,"wb");
    else         fp =  fopen(filename,"ab");
  }

  

  

  time_t t=0,told=0, tstart=0;

  if (!AitInit()) {
		
		
		ReadRegisters();
		

      // Update UI
      int csrDetector = ReadSD4Register(ADDR_CSR_DETECTOR);

      int  value = ((GetBit(csrDetector, BIT_CSR_DET_ADCGAIN2) ? 1 : 0) << 1) |
                   ((GetBit(csrDetector, BIT_CSR_DET_ADCGAIN1) ? 1 : 0) << 0);
      SetCtrlVal (ait, AIT_GETADCGAIN, value);
      double valued = GetThreshold();
      SetCtrlVal (ait, AIT_GETADCTHRESHOLD, valued);
      valued = GetIntegrationTime();
      SetCtrlVal (ait, AIT_GETADCINTEGRATIONTIME, valued);
      valued = GetHvVoltage(ADDR_HV_VMON);
      SetCtrlVal (ait, AIT_BIASMON, valued);
			
			value =
			((GetBit(csrDetector, BIT_CSR_DET_SUMGAIN4) ? 1 : 0) << 3) |
			((GetBit(csrDetector, BIT_CSR_DET_SUMGAIN3) ? 1 : 0) << 2) |
			((GetBit(csrDetector, BIT_CSR_DET_SUMGAIN2) ? 1 : 0) << 1) |
			((GetBit(csrDetector, BIT_CSR_DET_SUMGAIN1) ? 1 : 0) << 0);
      SetCtrlVal (ait, AIT_GETADCSUMGAIN, value);
			

		
    RefreshGraphs (ait, 0 , EVENT_COMMIT ,NULL, 0, 0 );
    
    daq_on=1;
		//RefreshGraphs (ait, 0 , EVENT_TIMER_TICK ,NULL, 0, 0 );    
    time(&tstart);
    told=tstart;
    int i=0;
    for (i=0; i<neve; i++) {
      start_timer(1);// 1 s timeout
      // Set ADC reset
      ResetAdc(true);
      // Clear ADC reset
      ResetAdc(false);
      int eventsAcquired = Acquire(pfreq);
			stop_timer();
			if (!daq_on) break; 
			if (timeout) {
			   i--;
				 printf("INFO Timeout\n");
				 continue;
			}
      int isvalid =1;
      if (eventsAcquired < 1) {
        printf("Acquired events %d\n", eventsAcquired);
        isvalid = 0;
      } else {
        AitFillHistograms(eventsAcquired);
        if (verbose) ShowEvent(1);
      }

      int nb =  ( isvalid && fp ) ? AitToFile( fp , pfreq ) : 0;
      SetCtrlVal(ait,AIT_CEVE,i);
      if (!isvalid) i--;
      
      time(&t);
      if (t!=told ) {
        rate =  (i-neveold);
        printf("%d events in %2.2f min (%d s) Rate %f Hz %s   ",i+1, (double)(t-tstart)/60.,(t-tstart), rate , ctime(&t));
        neveold = i;
				RefreshGraphs (ait, 0 , EVENT_COMMIT ,NULL, 0, 0 );  
        double daqBlocksize = GetAdcEventSize() * pfreq * 2.0;
        double daqTimeMs = BlockTransferTime();
        double daqTransferRate = daqBlocksize / daqTimeMs;
        SetCtrlVal(ait,AIT_DAQBLOCKSIZE, daqBlocksize);
        SetCtrlVal(ait,AIT_DAQTIMEMS,daqTimeMs);
        SetCtrlVal(ait,AIT_DAQTRANSFERRATE,daqTransferRate);
      }
      told=t;



    }
    time(&t);
    printf("%d events in %2.2f min (%d s) %s",i+1, (double)(t-tstart)/60.,t-tstart, ctime(&t));

  }

  if (fp) fclose(fp);

 
	RefreshGraphs (ait, 0 , EVENT_TIMER_TICK ,NULL, 0, 0 );
  return 0;

}


int CVICALLBACK scan(void *functionData) {

	int dx[3]={0,0,0};
	int nx[3]={0,0,0};
	int x0[3]={0,0,0};
	int ix[3]={0,0,0};
	int idx[3]={0,0,0};   
	unsigned short size;
	unsigned short posrec={0x2};	
	unsigned short runbuf={0x3};
	
	int  n[3];
	char filename[0xFF];
	char fname[0xff];  
	char pname[0xff];
	int enabledoutput;
	
	FILE *fp;
	GetCtrlVal(ait, AIT_FILENAME, fname );
	GetCtrlVal(ait, AIT_PATHNAME, pname );
	sprintf(filename,"%s/%s", pname, fname);
	
	GetCtrlVal(ait,AIT_ENABLEDOUTPUT, &enabledoutput);
	int fsize;
	if ( GetFileInfo(filename,&fsize) ) {
		 MessagePopup ("Warning", "File exist. Remove it first or choose another file");
	   return 0;
	}	 
	GetCtrlVal(xyscan, SCAN_STEPX, &dx[0]);
	GetCtrlVal(xyscan, SCAN_STEPY, &dx[1]);
	GetCtrlVal(xyscan, SCAN_NSTEPSX, &nx[0]);
	GetCtrlVal(xyscan, SCAN_NSTEPSY, &nx[1]);
	GetCtrlVal(xyscan, SCAN_STARTX, &x0[0]);
	GetCtrlVal(xyscan, SCAN_STARTY, &x0[1]);

	
	if (enabledoutput) { 
				fp =  fopen(filename,"ab");
				if (fp) {
					 size=36;
					 fwrite(&runbuf, sizeof(unsigned short),1 ,fp);
					 fwrite(&size  , sizeof(unsigned short),1 ,fp);
					 fwrite(x0    , 1,4*3 ,fp);
					 fwrite(dx    , 1,4*3 ,fp);
					 fwrite(nx    , 1,4*3 ,fp);
					 fclose(fp);
				}    
	}	
	
  for (int j=0; j<nx[1]; j++) {
			
	 SetCtrlVal (xyscan, SCAN_IY, j);
	 ix[1]= x0[1]+j*dx[1];
#ifdef MIKRO
		MIKRO_MoveTo(2,ix[1]);
		MIKRO_GetPosition(2,&n[1]);
			SetCtrlVal (xyscan, SCAN_YP, n[1]);
#endif		
			
	 for (int i=0; i<nx[0]; i++) {
		SetCtrlVal (xyscan, SCAN_IX, i);   
		ix[0]= x0[0]+i*dx[0];
#ifdef MIKRO
		  MIKRO_MoveTo(1,ix[0]);
			MIKRO_GetPosition(1,&n[0]);
			SetCtrlVal (xyscan, SCAN_XP, n[0]);
			
	
			if (enabledoutput) { 
				fp =  fopen(filename,"ab");
				if (fp) {
					 time_t mtime;
					 idx[0]=i;
					 idx[1]=j; 
					 size=24+sizeof(mtime);
					 fwrite(&posrec, sizeof(unsigned short),1 ,fp);
					 fwrite(&size  , sizeof(unsigned short),1 ,fp);
					 fwrite(n     , 1,4*3 ,fp);
					 fwrite(idx    , 1,4*3 ,fp);
					 time(&mtime);   
					 fwrite(&mtime  , sizeof(time_t),1 ,fp); 
					 fclose(fp);
				}    
			}	
				
#endif
			int newfile=0;
			daq(&newfile);
			if (!daq_on) break;
		}
		if (!daq_on) break; 
	}

	return 0;
}


int main (int argc, char *argv[]) {
	short port;
  if (InitCVIRTE (0, argv, 0) == 0)
    return -1;  /* out of memory */
  if ((ait = LoadPanel (0, "AitGui.uir", AIT)) < 0)
    return -1;
  if ((xyscan = LoadPanel (0, "XYSCAN.uir", SCAN)) < 0)
    return -1;
  SetStdioPort (CVI_STDIO_WINDOW);
  SetSleepPolicy(VAL_SLEEP_MORE);
  CmtNewThreadPool (MAX_THREADS,  &poolHandle);
  DisplayPanel (ait);
  DisplayPanel (xyscan);
  AitInit();
	
		
#ifdef MIKRO
	GetCtrlVal(xyscan, SCAN_PORT, &port);
	if (MIKRO_Open (port)) MessagePopup ("Error", "Mikro Port Not found !\n Change in the GUI") ;
	MIKRO_Init(1,0);
	MIKRO_Init(2,0);
#endif
	
	
  RunUserInterface ();
	
#ifdef MIKRO 	
	MIKRO_Close (); 
#endif   	
  DiscardPanel (ait);
  DiscardPanel (xyscan);
  return 0;
}

int CVICALLBACK StopCB (int panel, int control, int event,
                        void *callbackData, int eventData1, int eventData2) {
  switch (event) {
    case EVENT_COMMIT:
      daq_on=0;
      break;
  }
  return 0;
}


int CVICALLBACK StartCB (int panel, int control, int event,
                         void *callbackData, int eventData1, int eventData2) {
  ThreadFunctionPtr mythread = NULL;
  switch (event) {

    case EVENT_COMMIT:

      controlID= control;
      if (panel == ait && control == AIT_START) {
        mythread = daq;
        
      }
			if (panel == xyscan && control == SCAN_SCAN)   mythread = scan;  
      if (mythread!=NULL) {
        printf("New Thread panel=%d button=%d\n", panel, control);

        // SetDimming(1);

       
        CmtScheduleThreadPoolFunctionAdv (poolHandle, mythread, &controlID,
                                          DEFAULT_THREAD_PRIORITY,
                                          EndOfThread,
                                          EVENT_TP_THREAD_FUNCTION_END,
                                          NULL, RUN_IN_SCHEDULED_THREAD,
                                          &tfID);
      }
      break;
  }
  return 0;
}



int CVICALLBACK ExitCB (int panel, int control, int event,
                        void *callbackData, int eventData1, int eventData2) {
  switch (event) {
    case EVENT_COMMIT:
      QuitUserInterface (0);
      break;
  }
  return 0;
}

int CVICALLBACK ReadCB (int panel, int control, int event,
                        void *callbackData, int eventData1, int eventData2) {
  switch (event) {
    case EVENT_COMMIT:



      ReadRegisters();
      break;
  }
  return 0;
}

int CVICALLBACK ChangeChannelCB (int panel, int control, int event,
                                 void *callbackData, int eventData1, int eventData2) {
  int ch=0;
  switch (event) {
    case EVENT_COMMIT:

      int logy=0;
      GetCtrlVal(ait,AIT_CH, &ch);
			GetCtrlVal(ait,AIT_LOGY, &logy);
			if (logy){
				SetCtrlAttribute (ait, AIT_GRAPH, ATTR_YMAP_MODE, VAL_LOG);
			  SetCtrlAttribute (ait, AIT_GRAPHSUM, ATTR_YMAP_MODE, VAL_LOG); 
			
			} else {
				SetCtrlAttribute (ait, AIT_GRAPH, ATTR_YMAP_MODE, VAL_LINEAR);
			  SetCtrlAttribute (ait, AIT_GRAPHSUM, ATTR_YMAP_MODE, VAL_LINEAR); 
			
			}
      H1D_Draw(ch,ait,AIT_GRAPH,&plothandle[0]);
      break;
  }
  return 0;
}





int CVICALLBACK InitCB (int panel, int control, int event,
                        void *callbackData, int eventData1, int eventData2) {
  switch (event) {
    case EVENT_COMMIT:
      AitInit();
      break;
  }
  return 0;
}

int CVICALLBACK QuickCB (int panel, int control, int event,
                         void *callbackData, int eventData1, int eventData2) {
  switch (event) {
    case EVENT_COMMIT:
      switch (control) {
        case AIT_QUICKSETUP_1:
          QuickSetupContinuous();
					SetCtrlVal(ait,AIT_TRGTYPE, 0);
          break;
        case AIT_QUICKSETUP_2:
          QuickSetupDiscriminator();
					SetCtrlVal(ait,AIT_TRGTYPE, 2);
          break;
        case AIT_QUICKSETUP_3:
          QuickSetupTriggerOff();
			    break;


      }
			float bias = GetHvVoltage(ADDR_HV_VMON);
      SetCtrlVal (panel, AIT_BIASMON, bias);
			double	value = GetIntegrationTime();
      SetCtrlVal (panel, AIT_GETADCINTEGRATIONTIME, value);
			value = GetThreshold();
      SetCtrlVal (panel, AIT_GETADCTHRESHOLD, value);
			int csrDetector = ReadSD4Register(ADDR_CSR_DETECTOR);

      int ivalue = ((GetBit(csrDetector, BIT_CSR_DET_ADCGAIN2) ? 1 : 0) << 1) |
              ((GetBit(csrDetector, BIT_CSR_DET_ADCGAIN1) ? 1 : 0) << 0);
      SetCtrlVal (panel, AIT_GETADCGAIN, ivalue);
			ivalue =
			((GetBit(csrDetector, BIT_CSR_DET_SUMGAIN4) ? 1 : 0) << 3) |
			((GetBit(csrDetector, BIT_CSR_DET_SUMGAIN3) ? 1 : 0) << 2) |
			((GetBit(csrDetector, BIT_CSR_DET_SUMGAIN2) ? 1 : 0) << 1) |
			((GetBit(csrDetector, BIT_CSR_DET_SUMGAIN1) ? 1 : 0) << 0);
      SetCtrlVal (panel, AIT_GETADCSUMGAIN, ivalue);
      break;
  }
  return 0;
}



int CVICALLBACK MoveStageCB (int panel, int control, int event,
                             void *callbackData, int eventData1, int eventData2) {
  int axis=0, step=1000, direction=1;
  switch (event) {
    case EVENT_COMMIT:

      if (panel == xyscan) {
        switch (control) {
          case SCAN_BR :
            axis = 1;
            direction = 1;
            GetCtrlVal(panel, SCAN_STEPX, &step);
            break;
          case SCAN_BL :
            axis = 1;
            direction = -1;
            GetCtrlVal(panel, SCAN_STEPX, &step);
            break;
          case SCAN_BU :
            axis = 2;
            direction = 1;
            GetCtrlVal(panel, SCAN_STEPY, &step);
            break;
          case SCAN_BD :
            axis = 2;
            direction = -1;
            GetCtrlVal(panel, SCAN_STEPY, &step);
            break;
        }
#ifdef MIKRO
        {
          int n=0;
          MIKRO_MoveFor(axis,  direction*step );
          MIKRO_GetPosition(axis,&n);
          if (axis == 1) SetCtrlVal (panel, SCAN_XP, n);
          if (axis == 2) SetCtrlVal (panel, SCAN_YP, n);
        }
#endif // MIKRO         
      }

      break;
  }
  return 0;
}





int CVICALLBACK GoXCB (int panel, int control, int event,
                       void *callbackData, int eventData1, int eventData2) {
  int n2;
  switch (event) {
    case EVENT_COMMIT:
      GetCtrlVal (panel, SCAN_XG, &n2);
#ifdef MIKRO
      MIKRO_MoveTo(1,n2);
      MIKRO_GetPosition(1,&n2);

#endif
      SetCtrlVal (panel, SCAN_XP, n2);
      break;
  }
  return 0;
}

int CVICALLBACK GoYCB (int panel, int control, int event,
                       void *callbackData, int eventData1, int eventData2) {
  int n2;
  switch (event) {
    case EVENT_COMMIT:
      GetCtrlVal (panel, SCAN_YG, &n2);
#ifdef MIKRO
      MIKRO_MoveTo(2,n2);
      MIKRO_GetPosition(2,&n2);

#endif
      SetCtrlVal (panel, SCAN_YP, n2);
      break;
  }
  return 0;
}

int CVICALLBACK GetCurrentPositionCB (int panel, int control, int event,
                                      void *callbackData, int eventData1, int eventData2) {


  switch (event) {
    case EVENT_COMMIT: {
#ifdef MIKRO
      int n[2];
      MIKRO_GetPosition(1,&n[0]);
      SetCtrlVal (panel, SCAN_XP, n[0]);
      MIKRO_GetPosition(2,&n[1]);
      SetCtrlVal (panel, SCAN_YP, n[1]);
#endif
      break;
    }
  }
  return 0;
}

int CVICALLBACK HomeCB (int panel, int control, int event,
                        void *callbackData, int eventData1, int eventData2) {
  switch (event) {
    case EVENT_COMMIT:
#ifdef MIKRO
      MIKRO_ReferenceMove(1);
      MIKRO_ReferenceMove(2);
      GetCurrentPositionCB(panel, control, event, NULL, 0, 0);
#endif
      break;
  }
  return 0;
}

int CVICALLBACK SetBiasCB (int panel, int control, int event,
                           void *callbackData, int eventData1, int eventData2) {
  double bias=0;
  switch (event) {
    case EVENT_COMMIT:
      GetCtrlVal (panel, AIT_BIAS, &bias);
      SetHvVoltage(ADDR_HV_CTRL, bias);
      bias = GetHvVoltage(ADDR_HV_VMON);
      SetCtrlVal (panel, AIT_BIASMON, bias);
      break;
  }
  return 0;
}

int CVICALLBACK SetHvOnCB (int panel, int control, int event,
                           void *callbackData, int eventData1, int eventData2) {
  int state=0;
  double bias;
  switch (event) {
    case EVENT_COMMIT:
      GetCtrlVal (panel, control, &state);
      if (state) SetHvOn(true);
      else SetHvOn(false);
      bias = GetHvVoltage(ADDR_HV_VMON);
      SetCtrlVal (panel, AIT_BIASMON, bias);
      break;
  }
  return 0;
}

int CVICALLBACK SetAdcIntegrationTimeCB (int panel, int control, int event,
    void *callbackData, int eventData1, int eventData2) {

  switch (event) {
    case EVENT_COMMIT: {
      double value;
      GetCtrlVal (panel, AIT_ADCINTEGRATIONTIME, &value);
      SetIntegrationTime(value);
      value = GetIntegrationTime();
      SetCtrlVal (panel, AIT_GETADCINTEGRATIONTIME, value);
    }
    break;
  }
  return 0;
}

int CVICALLBACK SetAdcThresholdCB (int panel, int control, int event,
                                   void *callbackData, int eventData1, int eventData2) {
  switch (event) {
    case EVENT_COMMIT: {
      double value;
      GetCtrlVal (panel, AIT_ADCTHRESHOLD, &value);
      SetThreshold(value);
      value = GetThreshold();
      SetCtrlVal (panel, AIT_GETADCTHRESHOLD, value);
    }
    break;
  }
  return 0;
}

int CVICALLBACK SetAdcGainCB (int panel, int control, int event,
                              void *callbackData, int eventData1, int eventData2) {
  switch (event) {
    case EVENT_COMMIT: {
      int value;
      GetCtrlVal (panel, AIT_ADCGAIN, &value);
      SetAdcGain(value);
      int csrDetector = ReadSD4Register(ADDR_CSR_DETECTOR);

      value = ((GetBit(csrDetector, BIT_CSR_DET_ADCGAIN2) ? 1 : 0) << 1) |
              ((GetBit(csrDetector, BIT_CSR_DET_ADCGAIN1) ? 1 : 0) << 0);
      SetCtrlVal (panel, AIT_GETADCGAIN, value);
    }
    break;
  }
  return 0;
}

int CVICALLBACK SetAdcSumGainCB (int panel, int control, int event,
																 void *callbackData, int eventData1, int eventData2) {
	switch (event) {
		case EVENT_COMMIT:{
      int value;
      GetCtrlVal (panel, AIT_ADCSUMGAIN, &value);
      SetSumGain(value);
      int csrDetector = ReadSD4Register(ADDR_CSR_DETECTOR);
			value =
			((GetBit(csrDetector, BIT_CSR_DET_SUMGAIN4) ? 1 : 0) << 3) |
			((GetBit(csrDetector, BIT_CSR_DET_SUMGAIN3) ? 1 : 0) << 2) |
			((GetBit(csrDetector, BIT_CSR_DET_SUMGAIN2) ? 1 : 0) << 1) |
			((GetBit(csrDetector, BIT_CSR_DET_SUMGAIN1) ? 1 : 0) << 0);
      SetCtrlVal (panel, AIT_GETADCSUMGAIN, value);
    }

			break;
	}
	return 0;
}

int CVICALLBACK SetDiscriminatorTypeCB (int panel, int control, int event,
																				void *callbackData, int eventData1, int eventData2) {
	switch (event) {
		case EVENT_COMMIT:{
				int trgtype; 
	  		GetCtrlVal(ait,AIT_TRGTYPE, &trgtype); 
  	    EnableTrigger(trgtype); 
		}		
			break;
	}
	return 0;
}

int CVICALLBACK ResetCB (int panel, int control, int event,
												 void *callbackData, int eventData1, int eventData2) {
	switch (event) {
		case EVENT_COMMIT:
			ReconfigureDevice() ;
			ReconnectDevice(); 
			//ResetDevice() ;
			break;
	}
	return 0;
}

int CVICALLBACK OpenScanCB (int panel, int control, int event,
														void *callbackData, int eventData1, int eventData2) {
	switch (event) {
		case EVENT_COMMIT:
			DisplayPanel (xyscan); 
			break;
	}
	return 0;
}

int CVICALLBACK OpenMainCB (int panel, int control, int event,
														void *callbackData, int eventData1, int eventData2) {
	switch (event) {
		case EVENT_COMMIT:
			DisplayPanel (ait);  
			break;
	}
	return 0;
}
