#ifndef AITINTERFACE_H
#define AITINTERFACE_H

void SetupAcquisition(int neve);
void GetStatistics(int events);
int Acquire(int events);
void InitInterface(int events);
void ShowEvent(int eventNumber);
int ExtractEventCount(int eventNum);
long ExtractTimeStamp(int eventNum);
unsigned short ExtractAdcData(int eventNum,int channel);
int GetEventPosition(int eventNum);
int GetAdcEventSize();
void InitializeConnection();
void ReconfigureDevice();
void ReconnectDevice();
void ResetDevice();
int UpdateDeviceList();
void GetDeviceId();
void ReadRegisters();
void QuickSetupTriggerOff();
void QuickSetupDiscriminator();
void QuickSetupContinuous();
void SetAdcOffsets(int offsetInMv);
void SetAdcGain(int gain);
double GetRampRate();
void SetRampRate(double voltsPerSecond);
void CycleHvReset();
void SetMaximumHvSetting(double volts);
void SetHvOn(bool hvOn);
double GetHvVoltageSetting();
double GetHvIlimitSetting();
void SetHvVoltage(int reg,double volts);
void SetHvCurrentLimit(double milliamps);
void SetDetectorVaHiRange(bool range);
void SetDetectorVaOn(bool on);
void AddChannelNumber(bool addChannelNumber);
extern bool addTimeStamp;
void AddTimeStamp(bool addTimeStamp);
extern bool addEventCount;
void AddEventCount(bool addEventCount);
void SetAdcOffset(int reg,double milliVolts);
double GetAdcOffsetInMv(int reg);
void ResetAdc(bool reset);
void SetAdcCoupling(bool acCoupling);
int GetIntegrationTime();
void SetIntegrationTime(int integrationTime);
void SetDeadTime(int deadTimeInNs);
void DisableTriggers();
void EnableTrigger(int bitIndex);
void SetTriggerBurst(int triggerBurst);
void SetTriggerInterval(int triggerInterval);
void SetSumOffset(double milliVolts);
double GetSumOffsetInMv();
double GetThreshold();
void SetThreshold(double thresholdInMillivolts);
void SetSumCoupling(bool acCoupling);
void SetSumGain(int gain);
double GetVoltage75(int reg);
double GetHvCurrentInUa();
double GetHvVoltage(int reg);
double GetDetectorTemperature();
double GetVoltage(int reg);
int ReadAdcByteBuffer();
int ReadAdcBuffer();
int BlockTransferTime();
double LimitSetting(double value,double min,double max);
void ReadModifyWrite(int reg,int bitIndex,bool bitValue);
void WriteSD4Register32(int addrHi,int addrLo,unsigned int data);
void WriteSD4Register(int address,unsigned short data);
unsigned int ReadSD4Register32(int addrHi,int addrLo);
unsigned short ReadSD4Register(int reg);
bool GetBit(int data,int bitIndex);
unsigned short SetBit(unsigned short data,int bitIndex,bool bitValue);
void Sleep(int musec);
extern int TIMESTAMP_LSB;
extern bool addChannelNum;
extern const int ADCMAX;
extern const int CHANNELS;
extern const char statusDone[0xFF];
extern const char statusReconnect[0xFF];
extern const char statusReset[0xFF];
extern const char statusReconfig[0xFF];
extern const char statusNoDevice[0xFF];
extern const double RAMPRATESCALE;
extern const int INTEGRATOR_LSB;
extern const double HV_VRANGE;
extern const double HV_IRANGE;
extern const double DISCR_THRESHOLDRANGE;
extern const double DISCR_OFFSETRANGE;
extern const double MONADC_VRANGE;
extern const double DAC_SCALE;
extern const double MONADC_SCALE;
extern int histogramTotalEvents;
extern int histogramtotal[0xFFF *4];
extern int histograms[4][0xFFF];
extern unsigned short *adcBuffer;
extern int adcBufferLen;
extern int deviceIndex;
extern unsigned int deviceId;
#if defined(_CVI_)
int sprintf_s(const char *dest,int len,const char *format,...);
#endif
int AddMessage(const char *format,...);

#endif
