#ifndef AITMDUMANAGER_DEF_H
#define AITMDUMANAGER_DEF_H

// Registers 0-15 ( RESERVED - DO NOT ACCESS


//----------------------------------------
// ADC Controller Registers
//----------------------------------------

#define ADDR_BASE ( 16)
#define ADDR_CSR_MAIN ( ADDR_BASE + 0)	// Main CSR
#define ADDR_BUFFER ( ADDR_BASE + 1)	// ADC event buffer
#define ADDR_BUFFERWORDS ( ADDR_BASE + 2)	// 16-bit words available in the ADC event buffer
#define ADDR_EVENTID ( ADDR_BASE + 3)	// Event ID CSR
#define ADDR_CSR_DETECTOR ( ADDR_BASE + 4)	// Detector interface CSR
#define ADDR_TTLPORT ( ADDR_BASE + 5)	// TTL I/O port
#define ADDR_ITIME ( ADDR_BASE + 6)	// Integration time
#define ADDR_CSR_TRIGGER ( ADDR_BASE + 7)	// Trigger CSR
#define ADDR_DEADTIME ( ADDR_BASE + 8)	// Trigger dead time
#define ADDR_TG_INTERVALHI ( ADDR_BASE + 9)	// Internal trigger generator interval 31:16
#define ADDR_TG_INTERVALLO ( ADDR_BASE + 10)	// Internal trigger generator interval 15:0
#define ADDR_TG_COUNTHI ( ADDR_BASE + 11)	// Internal trigger generator burst count 31:16
#define ADDR_TG_COUNTLO ( ADDR_BASE + 12)	// Internal trigger generator burst count 15:0
#define ADDR_TC_COUNTHI ( ADDR_BASE + 13)	// Trigger count 31:16
#define ADDR_TC_COUNTLO ( ADDR_BASE + 14)	// Trigger count 15:0
#define ADDR_TC_RATEHI ( ADDR_BASE + 15)	// Trigger rate 31:16
#define ADDR_TC_RATELO ( ADDR_BASE + 16)	// Trigger rate 15:0
#define ADDR_CONV_COUNTHI ( ADDR_BASE + 17)	// ADC conversion count 31:16
#define ADDR_CONV_COUNTLO ( ADDR_BASE + 18)	// ADC conversion count 15:0
#define ADDR_CONV_RATEHI ( ADDR_BASE + 19)	// ADC conversion rate 31:16
#define ADDR_CONV_RATELO ( ADDR_BASE + 20)	// ADC conversion rate 15:0
#define ADDR_DISCR_OFFSET ( ADDR_BASE + 21)	// Discriminator offset
#define ADDR_DISCR_THRESHOLD ( ADDR_BASE + 22)	// Discriminator threshold
#define ADDR_MAIN_P12 ( ADDR_BASE + 23)	// Main +1.2V power supply monitor
#define ADDR_RESERVED2 ( ADDR_BASE + 24)	// RESERVED
#define ADDR_MAIN_P33 ( ADDR_BASE + 25)	// Main +3.3V power supply monitor
#define ADDR_MAIN_P50 ( ADDR_BASE + 26)	// Main +5.0V power supply monitor
#define ADDR_MAIN_PVA ( ADDR_BASE + 27)	// Main power supply +VA voltage monitor
#define ADDR_MAIN_NVA ( ADDR_BASE + 28)	// Main power supply -VA voltage monitor
#define ADDR_HV_MAX ( ADDR_BASE + 29)	// HV maximum allowable control voltage
#define ADDR_HV_RAMPRATE ( ADDR_BASE + 30)	// HV ramp rate
#define ADDR_HV_CTRL ( ADDR_BASE + 31)	// HV control voltage
#define ADDR_HV_ILIMIT ( ADDR_BASE + 32)	// HV current limit
#define ADDR_HV_VMON ( ADDR_BASE + 33)	// HV output current monitor
#define ADDR_HV_IMON ( ADDR_BASE + 34)	// HV output voltage monitor
#define ADDR_BASE_TEMPERATURE ( ADDR_BASE + 35)	// Base temperature monitor
#define ADDR_BASE_PVA ( ADDR_BASE + 36)	// Base +VA power supply monitor
#define ADDR_BASE_NVA ( ADDR_BASE + 37)	// Base -VA power supply monitor
#define ADDR_OFFSET1 ( ADDR_BASE + 38)	// ADC offset 1
#define ADDR_OFFSET2 ( ADDR_BASE + 39)	// ADC offset 2
#define ADDR_OFFSET3 ( ADDR_BASE + 40)	// ADC offset 3
#define ADDR_OFFSET4 ( ADDR_BASE + 41)	// ADC offset 4


//----------------------------------------
// Main CSR bits
//----------------------------------------

															// bit 0 ( RESERVED
#define BIT_CSR_MAIN_P12 ( 1)		// +1.2V power supply status
										   // bit 2 ( RESERVED
#define BIT_CSR_MAIN_P33 ( 3)		// +3.3V power supply status
#define BIT_CSR_MAIN_P50 ( 4)		// +5.0V power supply status
#define BIT_CSR_MAIN_PVA ( 5)		// +VA power supply status
#define BIT_CSR_MAIN_NVA ( 6)		// -VA power supply status
										   // bits 12:7 ( RESERVED
#define BIT_CSR_MAIN_BFULL ( 13)		// ADC buffer full status
#define BIT_CSR_MAIN_BEMPTY ( 14)		// ADC buffer empty status
#define BIT_CSR_MAIN_ADCRESET ( 15)		// Reset ADC


//----------------------------------------
// Event ID CSR bits
//----------------------------------------

#define BIT_EVENTID_COUNT ( 0)		// Add event count to each Event Block (0(no, 1(yes)
#define BIT_EVENTID_TIME ( 1)		// Add time stamp to each Event Block (0(no, 1(yes)
#define BIT_EVENTID_CHNUM ( 2)		// Add channel number to each ADC data word (0(no, 1(yes)
									// bits 15:3 ( RESERVED


//----------------------------------------
// Detector interface CSR bits
//----------------------------------------

#define BIT_CSR_DET_VAENABLE ( 0)		// Detector Module +/-VA enable (0 ( disable, 1 ( enable)
#define BIT_CSR_DET_VAHIRNG ( 1)		// Detector Module +/-VA output range (0 ( low range, 1 ( high range)
#define BIT_CSR_DET_HVENABLE ( 2)		// Detector Module HV power supply (0 ( disable, 1 ( enable)
#define BIT_CSR_DET_HVRESET ( 3)		// Detector Module HV power supply fault reset (0 ( reset off, 1 ( reset on)
#define BIT_CSR_DET_SUMCOUPLING ( 4)		// Sum input coupling (0 ( DC, 1 ( AC)
#define BIT_CSR_DET_SUMGAIN1 ( 5)		// Sum gain switch 1 (0 ( open, 1 ( closed)
#define BIT_CSR_DET_SUMGAIN2 ( 6)		// Sum gain switch 2 (0 ( open, 1 ( closed)
#define BIT_CSR_DET_SUMGAIN3 ( 7)		// Sum gain switch 3 (0 ( open, 1 ( closed)
#define BIT_CSR_DET_SUMGAIN4 ( 8)		// Sum gain switch 4 (0 ( open, 1 ( closed)
#define BIT_CSR_DET_ADCCOUPLING ( 9)		// ADC input coupling (0 ( DC, 1 ( AC)
#define BIT_CSR_DET_ADCGAIN1 ( 10)		// ADC gain switch 1 (0 ( open, 1 ( closed)
#define BIT_CSR_DET_ADCGAIN2 ( 11)		// ADC gain switch 2 (0 ( open, 1 ( closed)
#define BIT_CSR_DET_HVGOOD ( 12)		// Detector Module HV status (0 ( fault, 1 ( good)
#define BIT_CSR_DET_PVAGOOD ( 13)		// Detector Module VA status (0 ( fault, 1 ( good)
#define BIT_CSR_DET_NVAGOOD ( 14)		// Detector Module VA status (0 ( fault, 1 ( good)
#define BIT_CSR_DET_TEMPVALID ( 15)		// Detector Module temperature status (0 ( fault, 1 ( connected)


//----------------------------------------
// Trigger CSR bits
//----------------------------------------

#define BIT_CSR_TRIG_CONTINUOUS ( 0)		// Internal continuous trigger (0(off, 1(on)
#define BIT_CSR_TRIG_BURST ( 1)		// Internal burst trigger (0(off, 0(on)
#define BIT_CSR_TRIG_DISCR ( 2)		// Discriminator trigger (0(off, 0(on)
#define BIT_CSR_TRIG_EXTERNAL ( 3)		// External trigger (0(off, 0(on)
												   // bits 15:4 ( RESERVED
#endif