%% MAKE CONNECTION AND READ DATA FROM SCOPE %%

DSO = actxcontrol('LeCroy.ActiveDSOCtrl.1'); % Load ActiveDSO control
invoke(DSO,'MakeConnection','IP:192.168.147.9'); % Substitute your choice of IP address here
format longE % Show longE format in command window response

%% set scope to a different state
NumAcq = 10;
invoke(DSO,'WriteString','*RST',true); 
pause(10); % wait 10 seconds for scope reset --  from this point  you can call a defined setup
clc; % clear command window
invoke(DSO,'WriteString','DISP OFF',true); % display off
disp('scope set to display off to improve response time');
% commands to set scope: trigger mode to normal
invoke(DSO,'WriteString','TRMD NORMAL',true); % arm trigger and wait 1 second
pause(1);
% set scope to wanted state vertical scale, hor.scale, trigger level, offset need to be 
% set  MANUALLY TO MATCH desired  reccord length --  DELETE LINES IF scope is
% set up already and then these settings are not needed
%
% C1 vertical offset to -06V
invoke(DSO,'WriteString','C1:OFST -0.6V',true);
% vertical scale to 200mV/div
invoke(DSO,'WriteString','C1:VDIV 0.2',true); %Set vdiv on C1
% set trigger level to correct value
invoke(DSO,'WriteString','C1:TRLV 0.5V',true); 
%
% above general setting...below setting for wanted record length capture
% transfer time test
%
disp('settings to transfer 1Ms to a remote PC');
% MSIZ to 1 Ms
invoke(DSO,'WriteString','MSIZ 1e6',true); % set max mem size to 1Ms
% 5us/div to capture 1Ms with the waverunner  @20Gs/s
invoke(DSO,'WriteString','TDIV 5e-6',true); 
% Arm trigger in single mode
invoke(DSO,'WriteString','TRMD SINGLE;ARM',true); % enable single trigger mode
disp('scope armed and ready to capture data');
pause(1); % wait 1 seconds before starting capturing data for time trasnfer test
tic % start timer
for n=1:NumAcq
  invoke(DSO,'WriteString','TRMD SINGLE;WAIT;*OPC?',true); %Arm the trigger in single mode
  invoke(DSO,'WriteString','C1:WF?',true); % 
  Data=invoke(DSO,'ReadBinary',1100000);% Read back SCOPE DATA  set to a bit more then 1Ms, will transfer only those sent
end
transfertime = toc; %stop timer
invoke(DSO,'WriteString','DISP ON',true); %Set display back on to show captured trace
invoke(DSO,'WriteString','TDIV?',true); %read the tdiv value
tdiv=invoke(DSO,'ReadString',10000);
pause(1); % pause to show captured trace on scope display
tdiv = str2num(tdiv)*10*n; %convert tdiv value to number,  compute total acquisition time, the convert to string
message = strcat('total time for : ', num2str(n,2), ' Acquisitions is =  ', num2str(transfertime,6), '  seconds');
disp(message);
message = strcat('total acquisition time =: ', num2str(tdiv,6), ' seconds');
disp(message);
transfertime = transfertime/n  - tdiv; %compute transfer time by removing the total acquisition time
% DATA HAS BEEN TRANSFERRED -- TERMINATE CONNECTION WITH SCOPE 
message = strcat('mean transfer time in :',int2str(n), ' Acqusitions is = ', num2str(transfertime,6), '  seconds');
disp(message);
disp('--------------------------------------------------------------------------------');
invoke(DSO,'WriteString','DISP OFF',true); 
disp('scope set to display off to improve response time');
disp('settings to transfer 5Ms to a remote PC');
% MSIZ to 5 Ms
invoke(DSO,'WriteString','MSIZ 5e6',true); % display of for transfer test
% 50us/div to capture 5Ms with the waverunner  @10Gs/s
invoke(DSO,'WriteString','TDIV 50e-6',true); 
% Arm trigger in single mode
invoke(DSO,'WriteString','TRMD SINGLE;ARM',true); % enable single trigger mode
disp('scope armed and ready to capture data');
pause(1); % wait 1 seconds before starting capturing data
tic % start timer
for n=1:NumAcq
  invoke(DSO,'WriteString','TRMD SINGLE;WAIT;*OPC?',true); %Arm the trigger in single mode
  invoke(DSO,'WriteString','C1:WF?',true); % 
  Data=invoke(DSO,'ReadBinary',5100000);% Read back SCOPE DATA  set to a bit more then 5Ms, so will transfer only those sent
end
transfertime = toc; %stop timer
invoke(DSO,'WriteString','DISP ON',true); %Set display back on to show captured trace
invoke(DSO,'WriteString','TDIV?',true); %read the tdiv value
tdiv=invoke(DSO,'ReadString',10000);
pause(1); % pause to show captured trace on scope display
tdiv = str2num(tdiv)*10*n; %convert tdiv value to number,  compute total acquisition time, the to string
message = strcat('total time for : ', num2str(n,2), ' Acquisitions is =  ', num2str(transfertime,6), '  seconds');
disp(message);
message = strcat('total acquisition time =: ', num2str(tdiv,6), ' seconds');
disp(message);
transfertime = transfertime/n  - tdiv; %compute transfer time by removing the total acquisition time
% DATA HAS BEEN TRANSFERRED -- TERMINATE CONNECTION WITH SCOPE 
message = strcat('mean transfer time in :',int2str(n), ' Acqusitions is = ', num2str(transfertime,6), '  seconds');
disp(message);
disp('-------------------------------------------------------------------------------');
invoke(DSO,'WriteString','DISP OFF',true); 
disp('scope set to display off to improve response time');
disp('settings to transfer 10Ms to a remote PC');
% MSIZ to 10 Ms
invoke(DSO,'WriteString','MSIZ 10e6',true); % display of for transfer test
% 50us/div to capture 10Ms with the waverunner  @20Gs/s
invoke(DSO,'WriteString','TDIV 50e-6',true); 
% Arm trigger in single mode
invoke(DSO,'WriteString','TRMD SINGLE;ARM',true); % enable single trigger mode
disp('scope armed and ready to capture data');
pause(1); % wait 1 seconds before starting capturing data
tic % start timer
for n=1:NumAcq
  invoke(DSO,'WriteString','TRMD SINGLE;WAIT;*OPC?',true); %Arm the trigger in single mode
  invoke(DSO,'WriteString','C1:WF?',true); % 
  Data=invoke(DSO,'ReadBinary',10100000);% Read back SCOPE DATA  set to a bit more then 10Ms, so will transfer only those sent
end
transfertime = toc; %stop timer
invoke(DSO,'WriteString','DISP ON',true); %Set display back on to show captured trace
invoke(DSO,'WriteString','TDIV?',true); %read the tdiv value
tdiv=invoke(DSO,'ReadString',10000);
pause(1); % pause to show captured trace on scope display
tdiv = str2num(tdiv)*10*n; %convert tdiv value to number,  compute total acquisition time, the to string
message = strcat('total time for : ', num2str(n,2), ' Acquisitions is =  ', num2str(transfertime,6), '  seconds');
disp(message);
message = strcat('total acquisition time =: ', num2str(tdiv,6), ' seconds');
disp(message);
transfertime = transfertime/n  - tdiv; %compute transfer time by removing the total acquisition time
% DATA HAS BEEN TRANSFERRED -- TERMINATE CONNECTION WITH SCOPE 
message = strcat('mean transfer time in :',int2str(n), ' Acqusitions is = ', num2str(transfertime,6), '  seconds');
disp(message);
invoke(DSO,'Disconnect'); % disconnect from scope
close(gcf); % close current figure that had been opened by the activexcontrol
display ('test concluded');  

