#  
# M.Mastrofini Example of Scope remote control using Python
#  July 2014 -  ver 1.0
#  example using direct commands and VBS commands
#  Wincom extension must be installed
#
import win32com.client #imports the pywin32 library
scope=win32com.client.Dispatch("LeCroy.ActiveDSOCtrl.1")  #creates instance of the ActiveDSO control
#ActiveDso must be installed
scope.MakeConnection("IP:169.254.125.200") #Connects to the oscilloscope.  Substitute your IP address
import numpy
import matplotlib.pyplot as plt
scope.WriteString("VBS 'app.Acquisition.C1.VerScale = 0.1'",1)
CMD="VBS "+"'app.Display.GridMode = " +'"Single"'+"'"
print(CMD)
scope.WriteString(CMD,1)

value = "example of acquisition synchronization using *OPC?"
scope.WriteString("COMM_HEADER OFF",1)
scope.WriteString("COMM_FORMAT DEF9,Byte,BIN",1) # set scope to format header off and #word (2 bytes x sample) data transfer
#
#scope.WriteString("COMM_FORMAT OFF, BYTE, BIN",1) # set scope to format header off and word (1 bytes x sample) data transfer
#
# stop trigger and check if the scope is in stop mode
# during long acquisitions the scope may still be recording data
#
scope.WriteString("TRMD STOP",1)
value = ""
scope.WriteString("TRMD?",1)
value = scope.ReadString(80)
while value != "STOP":
    scope.WriteString("TRMD?",1)
    value = scope.ReadString(80)
print (value)
# Scope is now in idle mode
scope.WriteString("TRMD SINGLE",1)
scope.WriteString("TRMD?",1)
value = "now scope is in " + scope.ReadString(80) + " trigger mode"
print (value)
value = ""
# Arming trigger and sedn wait command, in order to respond With 1 to *OPC? only when operation is completed
scope.WriteString("ARM;WAIT",1)
print ("scope armed, waiting for OPC ")
while value != "1":
    scope.WriteString("*OPC?",1)
    value = scope.ReadString(1)
print (" opc = " + value)
print ( " scope has captured a waveform")
value = " "
scope.WriteString("CFMT?",1)
value = scope.ReadString(80)
print (value)
scope.WriteString("VBS? 'return=app.Acquisition.C1.VerScale",1)
value = scope.ReadString(80)
print (value)
vertical_Scale= float(value)
scope.WriteString("VBS? 'return=app.Acquisition.C1.VerOffset",1)
value = scope.ReadString(80)
print (" vertical offset = " + value)
Voffset= float(value)
scope.WriteString("VBS? 'return=app.Acquisition.Horizontal.HorScale",1)
value = scope.ReadString(80)
T= float(value)
print (T)
scope.WriteString("C1:WF? DAT1",1)
#read first 15 bytes, to determine how many bytes need to be transferred 
header = scope.ReadBinary(16)
print (header)
rlen = int(header[7:16]) 
print (rlen)
points = rlen
T0=-T*5
print (T0)
T1=T*5
print (T1)
#read from scope the waveform data
dataword = scope.ReadBinary(rlen)
x=numpy.arange(T0, T1, rlen)# horizontal scale vector in uS

# converting the binary data to 16 bit integers because reading 2 byte per sample. Modify accordingly if readin 1 byte per sample
data = numpy.fromstring(dataword, dtype=numpy.int8)
data = (data * vertical_Scale/32) - Voffset

#print data
plt.ylim((-vertical_Scale*4)-Voffset,(vertical_Scale*4)-Voffset)
plt.xlim(0, rlen)
plt.plot(data)
plt.show()
