clearvars;
DSO = actxcontrol('LeCroy.ActiveDSOCtrl.1'); % Load ActiveDSO control
invoke(DSO,'MakeConnection','IP:192.168.147.7'); % Substitute your choice of IP address here
Num_Points = 1e6; % Max number of samples the scope will capture
Sample_Rate = 1e9; % Sample rate, used to defiune the Horizzontal scale t/div
Header_Bytes = 10; % Fixed number to skip the header data in the plot
NumAcq = 10; % define the numnber of acqusititions to calculate the average transfer time
Transfer_Bytes = (Num_Points+Header_Bytes)*2; % number of bytes that will be sent in a word format
invoke(DSO,'WriteString','CHDR OFF',true); %turn command header Off
invoke(DSO,'WriteString','CHDR?',true);
Header=invoke(DSO,'Readstring',40);
display(Header);
%% set scope to a different state

invoke(DSO,'WriteString','*RST',true); 
pause(5);
clc;
clear ALL;
invoke(DSO,'WriteString','TRMD NORMAL',true); % arm trigger and wait 1 second
% set scope to wanted state vertical scale, hor.scale, trigger level, offset need to be 
% set  MANUALLY TO MATCH desired  reccord length --  DELETE LINES IF scope is
% set up already and then these settings are not needed
%
% C1 vertical offset to -0.1V
invoke(DSO,'WriteString','C1:OFST 0V',true);
% vertical scale to 200mV/div
invoke(DSO,'WriteString','C1:VDIV 0.05',true); %Set vdiv on C1
% MSIZ to 1Ms
Msize= strcat('MSIZ ', [char(32) num2str(Num_Points)]);
invoke(DSO,'WriteString', Msize, true); % set max mem size to 10Ks
% set trigger level to correct value
invoke(DSO,'WriteString','C1:TRLV 0.2V',true); 
% 10us/div to capture 1Ms with the waverunner  @10Gs/s% check manually and sett correct values for the desired record length capture
TDIV = strcat('TDIV', [char(32) num2str(Num_Points/Sample_Rate/10)]);
invoke(DSO,'WriteString',TDIV,true); 
% set record length to 1Ms
invoke(DSO,'WriteString','CFMT OFF, WORD, BIN',true); %Specify the data to be returned in Word format
%pause(1); % wait 1 seconds before starting capturing data
disp('scope armed and ready to capture data');
invoke(DSO,'WriteString','DISP OFF',true); %Set display off to minimize response time
tic % start timer
% % % TRANSFER WAVEFORM FROM SCOPE TO MATLAB 
for n=1:NumAcq
  invoke(DSO,'WriteString','TRMD SINGLE;ARM;WAIT;C1:WF? DAT1',true); %Arm the trigger in single mode
  Data=invoke(DSO,'ReadBinary',Transfer_Bytes); % read > 2x recordlength for 16bits/smaple 
end
transfertime = toc; %stop timer
invoke(DSO,'WriteString','DISP ON',true); %Set display back on to show captured trace
invoke(DSO,'WriteString','TDIV?',true); %read the tdiv value
tdiv=invoke(DSO,'ReadString',50);
tdiv = str2num(tdiv)*10*n; %convert tdiv value to number,  compute total acquisition time, the to string
message = strcat('total time for : ', num2str(n,2), ' Acquisitions is =  ', num2str(transfertime,6), '  seconds');
disp(message);
message = strcat('total acquisition time =: ', num2str(tdiv,6), ' seconds');
disp(message);
message = strcat('transfered', [char(32) num2str(Num_Points) char(32)], ' Points');
disp(message);
transfertime = transfertime/n  - tdiv; %compute transfer time by removing the total acquisition time
% DATA HAS BEEN TRANSFERRED -- TERMINATE CONNECTION WITH SCOPE 
message = strcat('mean transfer time in :',int2str(n), ' Acqusitions is = ', num2str(transfertime,6), '  seconds');
disp(message);
invoke(DSO,'Disconnect'); % disconnect from scope
close(gcf); % close current figure that had been opened by the activexcontrol
