﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace AutomationFormsApp1
{
    public partial class Form1 : Form
    {
        dynamic scope = (null); // scope is the object referring to LecroyXstreamDSO - must be defined here to be used in all buttons
        dynamic CMD = " ";      // CMD is a variant type (or dynamic as stated here) for commands
        dynamic Replay = " ";   // Replay is used as a returned string to quarries
        dynamic value = 1;      // value is used mainly for waituntilidle() to make sure scope is ready
        dynamic RSdoubleVector; // this will be used to transfer the waveform real data from scope
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // scope has been defined at upper level, and here is correclty populated, pointing to the needed object
            // to  communicate with the osciloscope from any other object 
            // (button, label, chart...) defined later in the Form1
            scope = Activator.CreateInstance(Type.GetTypeFromProgID("LeCroy.XStreamDSO"));
            scope.Acquisition.TriggerMode = "auto";  // set scope to auto trigger
            Replay = scope.InstrumentID;             // read instrument ID
            label2.Text += "\nGetting scope ID - trigger set to auto";
            var Replayvalue = Replay.Value;
            label1.Text = "You are controlling scope model:" + Replayvalue;
        }

        private void SingleTrigger_Click(object sender, EventArgs e)
        {
            label2.Text += "\nSingle trigger button clicked.....";
            scope.Acquisition.TriggerMode = "single";  //set single trigger mode 
        }

        private void MeasStatOn_Click(object sender, EventArgs e)
        {
            scope.Measure.ShowMeasure = true; // turn measure panel on
            scope.Measure.StatsOn = true;
            label2.Text += "\nMeasure and Statistics turned on";
        }

        private void CLSweeps_Click(object sender, EventArgs e)
        {
            label2.Text = "Clear Sweeps button clicked.....";
            scope.Measure.ClearSweeps.ActNow();
            label2.Text += ".....command executed";
        }

        private void DefSetup_Click(object sender, EventArgs e)
        {
            label2.Text = "Recall Default setup button clicked.....WAIT...";
            CMD = scope.SaveRecall.Setup.DoRecallDefaultPanel.ActNow();
            
            while (true)
            {
                value = scope.WaitUntilIdle(1);
                if (value == 1)
                {
                    break;
                }
            }
            scope.Acquisition.TriggerMode = "Auto";  //set auto trigger mode 
            label2.Text += ".....process completed";
        }

        private void UP_Click(object sender, EventArgs e)
        {
            CMD = scope.Acquisition.Horizontal.HorScaleUp.ActNow();
            scope.Acquisition.TriggerMode = "single";  //set single trigger mode 
            label2.Text = "Horizontal scale up button clicked";
        }

        private void down_Click(object sender, EventArgs e)
        {
            CMD = scope.Acquisition.Horizontal.HorScaleDown.ActNow();
            scope.Acquisition.TriggerMode = "single";  //set single trigger mode 
            label2.Text = "Horizontal scale down button clicked";
        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void label2_Click(object sender, EventArgs e)
        {

        }

        private void PlotWfm_Click(object sender, EventArgs e)
        {
            chart1.Series[0].Points.Clear();
            label2.Text = "Plot wfm button clicked.....";
            scope.Acquisition.TriggerMode = "stopped";  //set auto trigger mode 
            value = scope.Acquisition.Horizontal.NumPoints.Value;
            RSdoubleVector = scope.Acquisition.C1.Out.Result.DataArray();
            for (int i = 0; i < value - 1; i++)
            {
                chart1.Series[0].Points.AddXY(i, RSdoubleVector[i]);
            }
            label2.Text += ".....command executed";
        }
    }
}
