//------------------------------------------------------------------------------------------
// $Header: //mauisoft/main/Applications/Utilities/MultiWavePortClient/MultiPortClient.h#4 $
//------------------------------------------------------------------------------------------
// Summary:		Declaration of CFastMultiWavePort class
//
// Package:		Processing
//
// Authors:		Anthony Cake and Martin Miller
//
// Started:		03/27/2003
// Revised:		02/02/2007
// Revised:		01/07/2009
//
// LeCroy XStreamDSO, Copyright 2007 LeCroy Corporation. All Rights Reserved.
//
//------------------------------------------------------------------------------------------
//
#pragma once
//
//------------------------------------------------------------------------------------------
#pragma pack(push, 4)			// pack on 4-byte boundaries

#define FLAGS_OUTPUT_INVALID	0x01	// if set when returning from processing, don't read o/p result
#define FLAGS_OUTPUT_VALID		0x00	// if zeroth bit clear, then scope consumes o/p result


typedef unsigned __int64 lecStatusFlags;

#ifndef lecTimeStamp
typedef unsigned __int64 lecTimeStamp;
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////
//struct CDescHeader		// this is the single FastWavePort structure
//{
//	int descVersion;			// header version number
//	int flags;					// misc. flags indicating the status of input, and how to treat the output
//	int headerSize;				// size of the header, data starts immediately after the hdr.		
//	int windowSize;				// total size of the window	(header + data)		
//	int numSamples;				// total number of samples in the input waveform
//	int segmentIndex;			// index of this segment, usually zero when input waveform is not a sequence
//	int numSweeps;				
//	int _dummy1;				// not used
//
//	double verGain;				// scale factor that relates integer sample data values to the vertical units of the waveform.
//	double verOffset;			// vertical offset (in vertical units, e.g. Volts) of the waveform
//	double verResolution;		// vertical resolution of the measurement system (also in vertical units)
//	double horInterval;			// scale factor that relates integer sample indices to the horizontal units of the waveform.  
//	double horOffset;			// horizontal offset (in horizontal units, e.g. seconds) of the waveform 
//	double horResolution;		// horizontal resolution of the measurement system (also in horizontal units)
//	lecTimeStamp trigTime;		// trigger time, units of 1ns since 00:00:00 on Jan 1st 2000, 64-bit unsigned integer
//	char verUnit[48];			// vertical units of the waveform ("V" for example)
//	char horUnit[48];			// horizontal units of the waveform ("s" for example)
//};
///////////////////////////////////////////////////////////////////////////////////////////////////

const lecStatusFlags LStatus_Valid							= 0x0000000000000;	// for convenience ( a zero or no flag in bit position 1)
const lecStatusFlags LStatus_Invalid						= 0x0000000000001;	// for convenience (a non-zero value)
const lecStatusFlags LStatus_Overflow						= 0x0000000000002;	// indicates there were overflow values in the calculation
const lecStatusFlags LStatus_Underflow						= 0x0000000000004;	// indicates there were underflow values in the calculation
const lecStatusFlags LStatus_ContainsUndefinedValues		= 0x0000000000008;	// input or this result contains or contained undefined data
const lecStatusFlags LStatus_LessThan						= 0x0000000000010;	// parameterized value are deemed overestimates
const lecStatusFlags LStatus_GreaterThan					= 0x0000000000020;	// parameterized value are deemed underestimates
const lecStatusFlags LStatus_NotAPulse						= 0x0000000000040;	// source data was not classified as "pulse-like"
const lecStatusFlags LStatus_NotCyclic						= 0x0000000000080;	// source data was not classified as "cyclic"
const lecStatusFlags LStatus_Averaged						= 0x0000000000100;	// parameterized value is an average of values
const lecStatusFlags LStatus_UnlockedPLL					= 0x0000000000200;
const lecStatusFlags LStatus_OtherError						= 0x0000000000400;
const lecStatusFlags LStatus_OtherWarning					= 0x0000000000800;
const lecStatusFlags LStatus_OtherInfo						= 0x0000000001000;
const lecStatusFlags LStatus_Cumulative						= 0x0000000002000;
const lecStatusFlags LStatus_RisingEdge						= 0x0000000004000;	// was ReserveForParam1
const lecStatusFlags LStatus_FallingEdge					= 0x0000000008000;	// was ReserveForParam2
const lecStatusFlags LStatus_VirtualValue					= 0x0000000010000;	// was ReserveForParam3
const lecStatusFlags LStatus_HexaValue						= 0x0000000020000;	// was ReserveForParam4
const lecStatusFlags LStatus_ReserveForParam5				= 0x0000000040000;
const lecStatusFlags LStatus_ReserveForParam6				= 0x0000000080000;
const lecStatusFlags LStatus_ReserveForParam7				= 0x0000000100000;
const lecStatusFlags LStatus_ReserveForParam8				= 0x0000000200000;
const lecStatusFlags LStatus_NotNRZEye						= 0x0000000400000;
const lecStatusFlags LStatus_NotRZEye						= 0x0000000800000;
const lecStatusFlags LStatus_InputsIncompatible				= 0x0000100000000;
const lecStatusFlags LStatus_AlgorithmLimitsReached			= 0x0000200000000;
const lecStatusFlags LStatus_BadDefinition					= 0x0000400000000;
const lecStatusFlags LStatus_TooFewData						= 0x0000800000000;
const lecStatusFlags LStatus_TooManyData					= 0x0001000000000;
const lecStatusFlags LStatus_UniformHorizIntervalRequired	= 0x0002000000000;
const lecStatusFlags LStatus_BadUnits						= 0x0004000000000;
const lecStatusFlags LStatus_DataRangeTooLow				= 0x0008000000000;
const lecStatusFlags LStatus_DataUndersampled				= 0x0010000000000;
const lecStatusFlags LStatus_PoorStatistics					= 0x0020000000000;
const lecStatusFlags LStatus_SlowTransitionTime				= 0x0040000000000;
const lecStatusFlags LStatus_DataResampled					= 0x0080000000000;
const lecStatusFlags LStatus_DataInterpolated				= 0x0100000000000;
const lecStatusFlags LStatus_MeasurementScaleImprecise		= 0x0200000000000;
const lecStatusFlags LStatus_NoDataAvailable				= 0x0400000000000;
const lecStatusFlags LStatus_SomeCummulatedResultsInvalid	= 0x0800000000000;
const lecStatusFlags LStatus_InsufficientMemory				= 0x1000000000000;
const lecStatusFlags LStatus_ChannelNotActive				= 0x2000000000000;
const lecStatusFlags LStatus_UseStatusDescription			= 0x4000000000000;

struct CFrameInfo
{
	double horFrameStart;
	double horFrameStop;
	double verFrameStart;
	double verFrameStop;
};

typedef enum lecDescType
{
		_int16WformDescriptor,			// traditional 16-bit signed waveform result descriptor
		_floatWformDescriptor,			// 32-bit IEEE floating point waveform result descriptor
		_miniWaveformDescriptor,		// shared between 16-bit and 32-bit floating point waveform types
		_parameterDescriptor,
		_histogramDescriptor,
		_persistenceDescriptor,
		_tableDescriptor
} lecDescType;

struct CWaveDescHeader
{
	int				descVersion;		// header version number
	int				headerSize;			// size of this header, data starts immediately after the hdr.		
	int				windowSize;			// total size of the window	(header + data) in bytes		
	int				numHorVariances;	// for RIS how many horizontal variances (else zero)		
	lecDescType 	descType;			// (see enum above)
	lecStatusFlags	flags;				// misc. flags indicating the status of input, and how to treat the output
	int				numSegments;		// number of segments in this group or sequence		
	int				numSamples;			// total number of samples in the input waveform
	int				segmentIndex;		// index of this segment, usually zero when input waveform is not a sequence
	int				numSweeps;			// the number of acquisitions or "sweeps" which contributed to this waveform

	double			verGain;			// scale factor that relates integer sample data values to the vertical units of the waveform.
	double			verOffset;			// vertical offset (in vertical units, e.g. Volts) of the waveform
	double			verResolution;		// vertical resolution of the measurement system (also in vertical units)
	double			horInterval;		// scale factor that relates integer sample indices to the horizontal units of the waveform.  
	double			horOffset;			// horizontal offset (in horizontal units, e.g. seconds) of the waveform 
	double			horResolution;		// horizontal resolution of the measurement system (also in horizontal units)
	lecTimeStamp	trigTime;			// trigger time, units of 1ns since 00:00:00 on Jan 1st 2000, 64-bit unsigned integer
	char			verUnit[48];		// vertical units of the waveform ("V" for example)
	char			horUnit[48];		// horizontal units of the waveform ("s" for example)

	CFrameInfo		frameInfo;			// how this data was framed (typically inherited from source for
};
const int CWaveDescHeaderSize = sizeof(CWaveDescHeader);

struct CFloatWaveDescHeader
{
	int				descVersion;		// header version number
	int				headerSize;			// size of this header, data starts immediately after the hdr.		
	int				windowSize;			// total size of the window	(header + data) in bytes		
	int				numHorVariances;	// for RIS how many horizontal variances (else zero)		
	lecDescType 	descType;			// (see enum above)
	lecStatusFlags	flags;				// misc. flags indicating the status of input, and how to treat the output
	int				numSegments;		// number of segments in this group or sequence		
	int				numSamples;			// total number of samples in the input waveform
	int				segmentIndex;		// index of this segment, usually zero when input waveform is not a sequence
	int				numSweeps;			// the number of acquisitions or "sweeps" which contributed to this waveform

	double			verResolution;		// vertical resolution of the measurement system (also in vertical units)
	double			horInterval;		// scale factor that relates integer sample indices to the horizontal units of the waveform.  
	double			horOffset;			// horizontal offset (in horizontal units, e.g. seconds) of the waveform 
	double			horResolution;		// horizontal resolution of the measurement system (also in horizontal units)
	lecTimeStamp	trigTime;			// trigger time, units of 1ns since 00:00:00 on Jan 1st 2000, 64-bit unsigned integer
	char			verUnit[48];		// vertical units of the waveform ("V" for example)
	char			horUnit[48];		// horizontal units of the waveform ("s" for example)

	CFrameInfo		frameInfo;			// how this data was framed for display
};
const int CFloatWaveDescHeaderSize = sizeof(CFloatWaveDescHeader);

typedef double RIS_horVariance;
// when numHorVariances > 0, there is an array of these immediately following the header, but before the
// data value array


struct CWaveDescMiniHeader	// smaller version of the waveform descriptor, suitable for segmented acquisition
{
	int				descVersion;		// header version number
	int				headerSize;			// size of this header, data starts immediately after the hdr.		
	int				windowSize;			// total size of the window	(header + data) in bytes		
	int				numSamples;			// total number of samples in the input waveform
	lecDescType		descType;			// enumerated descriptor type (e.g. 16 bit signed waveform type)
	lecStatusFlags	flags;				// misc. flags indicating the status of input, and how to treat the output
	int				segmentIndex;		// index of this segment, usually zero when input waveform is not a sequence
	int				_dummy1;			// not used

	double			horOffset;			// horizontal offset (in horizontal units, e.g. seconds) of the waveform 
	lecTimeStamp	trigTime;			// trigger time, units of 1ns since 00:00:00 on Jan 1st 2000, 64-bit unsigned integer
};
const int CWaveDescMiniHeaderSize = sizeof(CWaveDescMiniHeader);

struct CParameterDescHeader
{
	int				descVersion;		// header version number
	int				headerSize;			// size of this header, data starts immediately after the hdr.		
	int				windowSize;			// total size of the window	(header + data) in bytes		
	int				numValues;			// total number of parameter values (produced)
	lecDescType 	descType;			// (see enum above)
	lecStatusFlags	flags;				// misc. flags indicating the status of result
	int				_dummy0;			// there is no numSweeps for parameters (was prior use of this position)
	int				_dummy1;			// not used

	double			verResolution;		// vertical resolution of the measurement values (in vertical units)
	double			horResolution;		// horizontal resolution of the measurement values (in horizontal units)
	lecTimeStamp	trigTime;			// trigger time, units of 1ns since 00:00:00 on Jan 1st 2000, 64-bit unsigned integer
	char			verUnit[48];		// vertical units of the waveform ("V" for example)
	char			horUnit[48];		// horizontal units of the waveform ("s" for example)
										
	double			inpHorInterval;		// scale information from input to this parameter  
	double			inpHorOffset;
	double			inpHorResolution;
	int				inpNumSamples;
	CFrameInfo		frameInfo;			// how this data was framed (typically inherited from source for
										// the parameter calculator

};

const int CParameterDescHeaderSize = sizeof(CParameterDescHeader);

struct CParameterValue
{
	double			value;				// a parametric result (with dimension of vertical units) 
	double			startOfRegion;		// horizontal coordinate of start of region from which this value was derived
	double			endOfRegion;		// horizontal coordinate of start of region from which this value was derived
	lecStatusFlags	flags;				// misc. flags indicating the status of value (e.g. + slope, virtual etc.)
};

const int CParameterValueSize = sizeof(CParameterValue);	// in principle (for win32) 4 x 64 with packing

#pragma pack(pop)				// restore packing
