//------------------------------------------------------------------------------------------
// FastWavePortClient.cpp : Defines the entry point for the console application.
//
// Prototype C++ client application for "Fast Wave Port' Math Processor
// 
// Anthony Cake, March 2003
//
// Compatibility:
//      Microsoft Visual C++ 6.0, 7.1, 8.0
//      MinGW 'gcc' based compiler (free download from http://www.mingw.org/)
//          Compile with: mingw32-c++ -o fastWavePortClient.exe fastwaveportclient.cpp
//------------------------------------------------------------------------------------------

#include "stdafx.h"
#include "windows.h"
#include "MultiPortClient.h"
#include <stdio.h>
#include <math.h>

//------------------------------------------------------------------------------------------
// FastWavePort header, describes various properties of the waveform passed to the user-processing
// function. Also used to carry the properties of the processed waveform back to the DSO.
//
//------------------------------------------------------------------------------------------
// Pentium read-time-stamp-counter instruction.
//#pragma warning(disable:4035)
#ifndef _WIN64
inline unsigned __int64 read64bitCounter()
{
    __asm rdtsc
}
#endif
//------------------------------------------------------------------------------------------

bool checkInt16WformHeader(CWaveDescHeader* descHeader)
{
	return (descHeader->descType == _int16WformDescriptor && descHeader->headerSize == CWaveDescHeaderSize);
}
//------------------------------------------------------------------------------------------
bool checkPmHeader(CParameterDescHeader* descHeader)
{
	return (descHeader->descType == _parameterDescriptor && descHeader->headerSize == CParameterDescHeaderSize);
}

//------------------------------------------------------------------------------------------

// The buffer size is 80MB (40,000,000 samples, stored as short integers) plus 0x1000 bytes for the header.
const unsigned long HEADER_SIZE = 0x1000;
const unsigned long MEM_MAP_FILE_SIZE_WAVEFORM = 80000000 + CWaveDescHeaderSize;		// = 40MSamples, or 80MBytes 
const unsigned long MEM_MAP_FILE_SIZE_PARAMETER = 1000 * CParameterValueSize + CParameterDescHeaderSize;	// some space 

int main(int argc, char* argv[])
{
    // names based on 'FMWavePort1' name defined in Processor setup.
    char szMapFileName1[]                    = "FMWavePort1FileIn1"; // waveport name
    char szMutexDataAvailableName[]         = "FMWavePort1MutexDataAvailable";// synch flag1
    char szMutexProcessingCompleteName[]    = "FMWavePort1MutexProcessingComplete";// synch flag2

    // Associate shared memory file handle value.
        HANDLE m_hMMFile1 = CreateFileMapping (INVALID_HANDLE_VALUE, NULL, PAGE_READWRITE, 0,  MEM_MAP_FILE_SIZE_WAVEFORM, szMapFileName1);
        if(m_hMMFile1 == 0)
        {
            printf("Unable to create file1 mapping\n");
            return 0;
        }
    
    // Map a view of this file for writing.
        short *m_lpMMFile1 = (short *)MapViewOfFile (m_hMMFile1, FILE_MAP_ALL_ACCESS, 0, 0,   0);                     
        if(m_lpMMFile1 == 0)
        {
            printf("Unable to map view of file1\n");
            return 0;
        }
    // create/open events used for synchronization
    // if the client app. was run before the scope then these events will be created, if the scope was run first then these events
    // will just be opened
        HANDLE m_hDataAvailable = CreateEvent(NULL, FALSE, FALSE /* initial state */, szMutexDataAvailableName);
        HANDLE m_hProcessingComplete = CreateEvent(NULL, FALSE, FALSE /* initial state */, szMutexProcessingCompleteName);
        if(m_hDataAvailable == 0 || m_hProcessingComplete == 0)
        {
            printf("Unable to open events\n");
            return 0;
        }

	//  install appropriate descriptors for two waveform results
		
			CWaveDescHeader* descWaveformHeader[1];
			descWaveformHeader[0] = (CWaveDescHeader *) m_lpMMFile1;
			//descWaveformHeader[1] = (CWaveDescHeader *) m_lpMMFile2;
			for(int i = 0; i < 1; ++i)
			{
				descWaveformHeader[i]->descType = _int16WformDescriptor;
				descWaveformHeader[i]->descVersion = 1;
				descWaveformHeader[i]->headerSize = CWaveDescHeaderSize;
				descWaveformHeader[i]->windowSize = MEM_MAP_FILE_SIZE_WAVEFORM;
				//descWaveformHeader[i]->hor
			}

			
			
	

    // main loop ... intereacting with the (FastMultiWavePort) processor in the scope
		int loopCount = 0;
        while(1)
        {
			if(loopCount % 64 == 0)
				printf("\nWaiting.");
			else
				printf(".");

			++loopCount;

            // wait an infinite amount of time for data to be available
                DWORD waitSuccess = WaitForSingleObject(m_hDataAvailable, INFINITE);
            // print the first few bytes of the input waveform
                CWaveDescHeader *descHeader = (CWaveDescHeader *) m_lpMMFile1;
				CWaveDescMiniHeader* descMiniHeader;
               

				if(checkInt16WformHeader(descHeader))
				{
					// protect against unterminated C-string ... jam a null char into the last available spot
					descHeader->verUnit[47] = '\0';
					descHeader->horUnit[47] = '\0';
					int numSegments1 = descHeader->numSegments;
					printf("\ntotal segments = %4d\n", numSegments1);
					printf("%6d samples per segment\n", descHeader->numSamples);
					printf("vertical units: %s\n, horizontal units %s\n", descHeader->verUnit, descHeader->horUnit );
					printf("vertical perStep: %14.5e\n, vertical offset %14.5e\n", descHeader->verGain, descHeader->verOffset );

					double horOffset = descHeader->horOffset;

					printf("hor Offset = %14.5e, hor Interval = %14.5e\n", descHeader->horOffset, descHeader->horInterval);

					// start and end of domain over which waveform spans. (note: numIntervals = numSamples - 1)
					int	numSamples = descHeader->numSamples;
					
					int numSamplesCommon = numSamples;

					// we set the domain to the common range, associated with the horizontal domain of input 1
					double startOfDomain = descHeader->horOffset;
					double endOfDomain = descHeader->horOffset + descHeader->horInterval * (numSamplesCommon - 1);


					short *m_lpWaveform = (short*)&m_lpMMFile1[CWaveDescHeaderSize / sizeof(short)];                      
					//short *m_lpWaveform2 = (short*)&m_lpMMFile2[CWaveDescHeaderSize / sizeof(short)];

					for(int segment = 0; segment < numSegments1; ++segment)
					{
						if(segment > 0)
						{
							// for segments after the first one, some information may (and probably does) change.
							descMiniHeader = (CWaveDescMiniHeader*)m_lpWaveform;
							m_lpWaveform += CWaveDescMiniHeaderSize / sizeof(short);
						
							numSamples = descMiniHeader->numSamples;
							//numSamples2 = descMiniHeader2->numSamples;
							numSamplesCommon =numSamples;
							startOfDomain = descMiniHeader->horOffset;
							endOfDomain = descMiniHeader->horOffset + descHeader->horInterval * (numSamplesCommon - 1);

							// check incomming hor offset and trigger time
							double horOffset = descMiniHeader->horOffset;
							lecTimeStamp trigTime = descMiniHeader->trigTime;

							int segmentIndex = descMiniHeader->segmentIndex;
						}
						// // Use this code to assure yourself there's something interesting in the first few points of data
						for(int i = 0; i < 4; ++i)
						{
							printf("%f (%4d),", (m_lpWaveform[i] * descHeader->verGain) + descHeader->verOffset, m_lpWaveform[i]);
							printf("\n");
							
						}
						

					// as an example ... compute the mean of all data values, while computing the abs value of the 
					// integer values for the waveform in-place
							for(int i = 0; i < numSamplesCommon; ++i)
							{
								m_lpWaveform[i] = -(m_lpWaveform[i]);
								
							}
						}

					// for this example ... we install the average as a parameter result for each segment
					
					}
					


				
				else
					printf("\nunexpected descriptor type (%d), expected (%d)", descHeader->descType, _int16WformDescriptor);

            // use to flag that the output is not valid, increasing performance when 
            // it is not necessary to read data back into the DSO
                //descHeader->flags |= LStatus_Invalid;

            // flag that processing is complete
                SetEvent(m_hProcessingComplete);
        }

    return 0;
}
